package com.simm.exhibitor.bean.shipment;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;

import lombok.*;

/**
* Created by Mybatis Generator on 2024/07/31 11:35
*/
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class ShipmentReviewExhibit extends BaseBean {
        /**
         * id
         */
    private Integer id;

    /**
     * 展商id
     */
    private String uniqueId;

    /**
     * 申报展品id
     */
    private Integer declareExhibitId;

    /**
     * 订单id
     */
    private Integer orderId;

    /**
     * 包装类型(1:包装,2:裸机)
     */
    private Integer packageType;

    /**
     * 空箱体积(cm³)
     */
    private BigDecimal packageVolume;

    /**
     * 空箱存储天数
     */
    private Integer storageDays;

    /**
     * 是否按重量收费
     */
    private Boolean weightBilling;

    /**
     * 展品长(单位:cm)
     */
    private Integer len;

    /**
     * 展品宽(单位:cm)
     */
    private Integer width;

    /**
     * 展品高(单位:cm)
     */
    private Integer height;

    /**
     * 展品体积(cm³)
     */
    private Integer volume;

    /**
     * 运输服务(1:进馆,2:出馆,3:进出馆)
     */
    private Integer transport;

    /**
     * 原价运输金额
     */
    private Integer originTransportAmount;

    /**
     * 运输金额(单位：分)
     */
    private Integer transportAmount;

    /**
     * 原价包装存储金额
     */
    private Integer originPackageAmount;

    /**
     * 包装存储金额(单位：分)
     */
    private Integer packageAmount;

    /**
     * 原价超限金额(单位：分)
     */
    private Integer originOverrunAmount;

    /**
     * 超限金额(单位：分)
     */
    private Integer overrunAmount;

    /**
     * 原价超重金额
     */
    private Integer originOverweightAmount;

    /**
     * 超重金额(单位：分)
     */
    private Integer overweightAmount;
    /**
     * 原价空箱搬运金额(单位：分)
     */
    private Integer originEmptyContainerAmount;
    /**
     * 空箱搬运金额(单位：分)
     */
    private Integer emptyContainerAmount;

    /**
     * 展品重量(单位:公斤)
     */
    private Integer weight;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 最后更新时间
     */
    private Date lastUpdateTime;
}