package com.simm.exhibitor.bean.shipmentv2;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
* Created by Mybatis Generator on 2022/12/08 10:16
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmebShipmentBase extends BaseBean {
    @ApiModelProperty("id")
    private Integer id;

    @ApiModelProperty("展商id")
    private String uniqueId;

    @ApiModelProperty("公司名")
    private String comFullName;

    @ApiModelProperty("展馆id")
    private String boothId;

    @ApiModelProperty("展位号")
    private String boothNo;

    @ApiModelProperty("联系人")
    private String contactName;

    @ApiModelProperty("联系电话")
    private String contactMobile;

    @ApiModelProperty("作业时间")
    private Date workDate;

    @ApiModelProperty("车牌")
    private String carNo;

    @ApiModelProperty("车牌图片")
    private String carNoUrl;

    @ApiModelProperty("申报总额(单位：分)")
    private Integer totalAmount;

    @ApiModelProperty("复核金额(单位：分)")
    private Integer orderAmount;

    @ApiModelProperty("实收金额(单位：分)")
    private Integer actualAmount;

    @ApiModelProperty("申报单url")
    private String declarationUrl;

    @ApiModelProperty("申报时间")
    private Date declarationTime;

    @ApiModelProperty("回签申报单url")
    private String declarationSignUrl;

    @ApiModelProperty("回签申报单时间")
    private Date declarationSignTime;

    @ApiModelProperty("是否锁定")
    private Boolean declarationLock;

    @ApiModelProperty("状态(1:正常,-1:删除)")
    private Integer status;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("作业单号")
    private String orderNo;
}