package com.simm.exhibitor.bean.shipmentv2;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import java.util.Date;

/**
* Created by Mybatis Generator on 2022/12/02 10:30
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmebShipmentExhibit extends BaseBean {

    private static final long serialVersionUID = 7129614645252520904L;

    @ApiModelProperty("id")
    private Integer id;

    @ApiModelProperty("展商id")
    private String uniqueId;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("展品名称")
    private String name;

    @ApiModelProperty("展品类别")
    private String category;

    @ApiModelProperty("公司名")
    private String businessName;

    @ApiModelProperty("包装类型(1:包装,2:裸机)")
    private Integer packageType;

    @ApiModelProperty("空箱体积(m³)")
    private Double packageVolume;

    @ApiModelProperty("空箱存储天数")
    private Integer storageDays;

    @ApiModelProperty("是否按重量收费")
    private Boolean weightBilling;

    @ApiModelProperty("展品长(单位:cm)")
    private Integer len;

    @ApiModelProperty("展品宽(单位:cm)")
    private Integer width;

    @ApiModelProperty("展品高(单位:cm)")
    private Integer height;

    @ApiModelProperty("展品体积(cm³)")
    private Integer volume;

    @ApiModelProperty("运输服务(1:进馆,2:出馆,3:进出馆)")
    private Integer transport;

    @ApiModelProperty("运输金额(单位：分)")
    private Integer transportAmount;

    @ApiModelProperty("包装存储金额(单位：分)")
    private Integer packageAmount;

    @ApiModelProperty("超限金额(单位：分)")
    private Integer overrunAmount;

    @ApiModelProperty("超重金额(单位：分)")
    private Integer overweightAmount;

    @ApiModelProperty("展品重量(单位:公斤)")
    private Integer weight;

    @ApiModelProperty("复核状态(0:待复核，1:已复核)")
    private Boolean review;

    @ApiModelProperty("包装类型(1:包装,2:裸机)")
    private Integer reviewPackageType;

    @ApiModelProperty("空箱存储体积(m³)")
    private Double reviewPackageVolume;

    @ApiModelProperty("空箱是否存储(0:否，1:是)")
    private Boolean reviewStore;

    @ApiModelProperty("空箱存储天数")
    private Integer reviewStorageDays;

    @ApiModelProperty("是否按重量收费")
    private Boolean reviewWeightBilling;

    @ApiModelProperty("展品长(单位:cm)")
    private Integer reviewLen;

    @ApiModelProperty("展品宽(单位:cm)")
    private Integer reviewWidth;

    @ApiModelProperty("展品高(单位:cm)")
    private Integer reviewHeight;

    @ApiModelProperty("展品体积(cm³)")
    private Integer reviewVolume;

    @ApiModelProperty("展品重量(单位:公斤)")
    private Integer reviewWeight;

    @ApiModelProperty("运输服务(1:进馆,2:出馆,3:进出馆)")
    private Integer reviewTransport;

    @ApiModelProperty("运输金额(单位：分)")
    private Integer reviewTransportAmount;

    @ApiModelProperty("包装存储金额(单位：分)")
    private Integer reviewPackageAmount;

    @ApiModelProperty("超限金额(单位：分)")
    private Integer reviewOverrunAmount;

    @ApiModelProperty("超重金额(单位：分)")
    private Integer reviewOverweightAmount;

    @ApiModelProperty("订单状态")
    private Integer orderStatus;

    @ApiModelProperty("申报方式(1:预申报，2:现场录入)")
    private Integer declareType;

    @ApiModelProperty("使用三件超重超限优惠订单编号")
    private String overrunDiscountOrderNo;

    @ApiModelProperty("备注")
    private String remark;

    @Override
    public String toString() {
        return "SmebShipmentExhibit{" +
                "id=" + id +
                ", uniqueId='" + uniqueId + '\'' +
                ", orderNo='" + orderNo + '\'' +
                ", name='" + name + '\'' +
                ", category='" + category + '\'' +
                ", businessName='" + businessName + '\'' +
                ", packageType=" + packageType +
                ", packageVolume=" + packageVolume +
                ", storageDays=" + storageDays +
                ", weightBilling=" + weightBilling +
                ", len=" + len +
                ", width=" + width +
                ", height=" + height +
                ", volume=" + volume +
                ", transport=" + transport +
                ", transportAmount=" + transportAmount +
                ", packageAmount=" + packageAmount +
                ", overrunAmount=" + overrunAmount +
                ", overweightAmount=" + overweightAmount +
                ", weight=" + weight +
                ", review=" + review +
                ", reviewPackageType=" + reviewPackageType +
                ", reviewPackageVolume=" + reviewPackageVolume +
                ", reviewStore=" + reviewStore +
                ", reviewStorageDays=" + reviewStorageDays +
                ", reviewWeightBilling=" + reviewWeightBilling +
                ", reviewLen=" + reviewLen +
                ", reviewWidth=" + reviewWidth +
                ", reviewHeight=" + reviewHeight +
                ", reviewVolume=" + reviewVolume +
                ", reviewWeight=" + reviewWeight +
                ", reviewTransport=" + reviewTransport +
                ", reviewTransportAmount=" + reviewTransportAmount +
                ", reviewPackageAmount=" + reviewPackageAmount +
                ", reviewOverrunAmount=" + reviewOverrunAmount +
                ", reviewOverweightAmount=" + reviewOverweightAmount +
                ", orderStatus=" + orderStatus +
                ", declareType=" + declareType +
                ", overrunDiscountOrderNo='" + overrunDiscountOrderNo + '\'' +
                ", remark='" + remark + '\'' +
                ", createTime=" + createTime +
                ", lastUpdateTime=" + lastUpdateTime +
                ", boothId='" + boothId + '\'' +
                '}';
    }

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;


    @ApiModelProperty("展馆")
    private String boothId;

    @ApiModelProperty("开始日期")
    private Date serviceStartDate;

    @ApiModelProperty("开始日期")
    private Date serviceEndDate;
}