package com.simm.exhibitor.bean.shipmentv2;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
* Created by Mybatis Generator on 2023/01/06 08:43
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmebShipmentOrder extends BaseBean {
    @ApiModelProperty("id")
    private Integer id;

    @ApiModelProperty("展商id")
    private String uniqueId;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("作业日期")
    private String workDate;

    @ApiModelProperty("订单金额")
    private Integer amount;

    @ApiModelProperty("实际金额")
    private Integer actualAmount;

    @ApiModelProperty("已领金额")
    private Integer paidAmount;

    @ApiModelProperty("进出馆金额")
    private Integer transportAmount;

    @ApiModelProperty("超重超限金额")
    private Integer overrunAmount;

    @ApiModelProperty("空箱存储金额")
    private Integer packageAmount;

    @ApiModelProperty("超重超限优惠金额")
    private Integer overrunDiscountAmount;

    @ApiModelProperty("空箱存储优惠金额")
    private Integer packageDiscountAmount;

    @ApiModelProperty("本单满足三件优惠，补回前面订单的超重超限优惠金额")
    private Integer historyOverrunDiscountAmount;

    @ApiModelProperty("其它优惠金额")
    private Integer otherDiscountAmount;

    @ApiModelProperty("订单状态(1:未付款,2:已付款,3:对公未付)")
    private Integer orderStatus;

    private Integer urgentInvoice;

    private Integer openInvoice;

    private Integer openInvoiceAmount;

    private Integer invoiceApply;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;
}