package com.simm.exhibitor.bean.shipmentv2;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
* Created by Mybatis Generator on 2022/12/02 10:12
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmebShipmentPaymentLog extends BaseBean {
    @ApiModelProperty("")
    private Integer id;

    @ApiModelProperty("展商唯一id")
    private String uniqueId;

    @ApiModelProperty("订单id(smerp_order.id)")
    private Integer orderId;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("流水号")
    private String serialNo;

    @ApiModelProperty("付款方式(1微信；2支付宝,3:现金, 4:自动领款 5：预付款金额）")
    private Integer payType;

    @ApiModelProperty("确认金额(单位:分)")
    private Integer confirmMoney;

    @ApiModelProperty("开票标识(1:未开票,2:已开票)")
    private Integer openInvoice;

    @ApiModelProperty("状态(1:正常,-1:回滚)")
    private Integer status;

    @ApiModelProperty("作废原因")
    private String reason;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新人")
    private String lastUpdateBy;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人id")
    private Integer createById;
}