package com.simm.exhibitor.bean.shipmentv2;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
* Created by Mybatis Generator on 2022/12/02 10:12
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmebShipmentService extends BaseBean {
    @ApiModelProperty("id")
    private Integer id;

    @ApiModelProperty("展商id")
    private String uniqueId;

    @ApiModelProperty("服务类型")
    private String type;

    @ApiModelProperty("服务名称")
    private String name;

    @ApiModelProperty("单位")
    private String unit;

    @ApiModelProperty("单价")
    private Integer price;

    @ApiModelProperty("总价")
    private Integer totalAmount;

    @ApiModelProperty("数量")
    private BigDecimal quantity;

    @ApiModelProperty("已用数量")
    private BigDecimal useQuantity;

    @ApiModelProperty("申报方式(1:预申报，2:现场录入)")
    private Integer declareType;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;
}