package com.simm.exhibitor.dto.exhibitor;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author liutao
 * @since 2024/6/5
 */
@Data
public class ExhibitorGroupInfoDTO {


    private Integer id;

    @NotBlank(message = "公司名称不能为空")
    private String comBusinessName;

    @NotBlank(message = "公司英文名称不能为空")
    private String comBusinessNameEn;

    @NotNull(message = "国家id不能为空")
    private Integer countryId;

    @NotBlank(message = "国家名称不能为空")
    private String countryName;

    @NotNull(message = "省份id不能为空")
    private Integer provinceId;

    @NotBlank(message = "省份名称不能为空")
    private String provinceName;

    @NotNull(message = "城市id不能为空")
    private Integer cityId;

    @NotBlank(message = "城市名称不能为空")
    private String cityName;

    @NotNull(message = "区域id不能为空")
    private Integer areaId;

    @NotBlank(message = "区域名称不能为空")
    private String areaName;

    @NotBlank(message = "主营产品不能为空")
    private String mainProduct;

    private String mainProductEn;

    @NotBlank(message = "公司座机不能为空")
    private String comBusinessTelphone;
    /**
     * 网站
     */
    private String comBusinessWebsite;

    /**
     * 会刊公司地址
     */
    private String comBusinessAddress;
    /**
     * 会刊公司地址英文
     */
    private String comBusinessAddressEn;
    /**
     * 展位号
     */
    private String boothNo;
}
