package com.simm.exhibitor.dto.invoice;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author liutao
 * @since 2024/7/2
 */
@Data
public class Invoice implements Serializable {

    private Integer id;
    /**
     * 展商id
     */
    private Integer exhibitorId;
    /**
     * 领款日志id
     */
    private Integer detailLogId;

    /**
     * 订单id
     */
    private Integer orderId;

    /**
     * 开票公司名称
     */
    private String businessName;
    /**
     * 发票类型(1:专票,2:普票)
     */
    private Integer invoiceType;

    /**
     * 税号
     */
    private String taxNo;

    /**
     * 纳税人识别号
     */
    private String taxpayerNo;

    /**
     * 纳税人类型 1 一般纳税人 2 非一般纳税人
     */
    private Integer taxpayerType;


    /**
     * 营业执照url
     */
    private String businessLicenseUrl;

    /**
     * 收件人邮箱
     */
    private String recipientsEmail;

    /**
     * 收款公司名
     */
    private String sponsorName;

    /**
     * 发票金额
     */
    private Integer invoiceAmount;

    /**
     * openid
     */
    private String openId;

    /**
     * 1 销售订单 2 水电订单 3 承运订单
     */
    private Integer platformType;

    /**
     * 领款日志id
     */
    private List<Integer> detailLogIds;
    /**
     * 订单id
     */
    private List<String> orderNos;


}
