package com.simm.exhibitor.dto.invoice;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author liutao
 * @since 2024/7/2
 */
@Data
public class PaymentDetailLog implements Serializable {

    private Integer id;

    private Integer detailId;

    /**
     * 展商id
     */
    private Integer exhibitorId;
    /**
     * 展商uniqueId
     */
    private String exhibitorUniqueId;

    /**
     * 订单id
     */
    private Integer orderId;
    /**
     * 订单号
     */
    private String orderNo;
    /**
     * 订单流水号
     */
    private String serialNo;
    /**
     * 合同公司名
     */
    private String agreementExhibitName;

    /**
     * 付款公司名
     */
    private String payBusinessName;
    /**
     * 主办方公司名
     */
    private String sponsorBusinessName;

    /**
     * 1 展位 2 广告 3 会议 4 水电 5 承运
     */
    private Integer productType;

    /**
     * 1 销售订单 2 水电订单 3 承运订单
     */
    private Integer platformType;

    /**
     * 年份
     */
    private Integer year;
    /**
     * 确认金额
     */
    private Integer confirmMoney;
    /**
     * 1 未开票 2 已开票
     */
    private Integer openInvoice;

    /**
     * 紧急发票 0 否 1 是
     */
    private Integer urgentInvoice;
    /**
     * 创建时间
     */
    private String createTime;
    /**
     * 发票资料id
     */
    private Integer invoiceBaseId;
    /**
     * 开票时间
     */
    private String openInvoiceTime;
    /**
     * 发票资料url
     */
    private String invoiceInformationUrl;
}
