package com.simm.exhibitor.dto.shipment;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;
import java.math.BigDecimal;

/**
 * @author liutao
 * @since 2023/11/6
 */
@Data
public class ShipmentExhibitImportExcelDTO {

    @ExcelProperty("序号")
    private Integer index;
    @ExcelProperty("展品名称")
    private String name;
    @ExcelProperty("*长(单位:厘米)")
    @Max(value = 2000, message = "长不能超过2000cm")
    @Min(value = 10,message = "长不能低于10cm")
    @NotNull(message = "长不能为空")
    @Digits(message = "长格式错误", integer = 4, fraction = 0)
    private Integer len;
    @ExcelProperty("*宽(单位:厘米)")
    @NotNull(message = "宽不能为空")
    @Max(value = 600, message = "宽不能超过600cm")
    @Min(value = 10,message = "宽不能低于10cm")
    @Digits(message = "宽格式错误", integer = 3, fraction = 0)
    private Integer width;
    @ExcelProperty("*高(单位:厘米)")
    @NotNull(message = "高不能为空")
    @Max(value = 600, message = "高不能超过600cm")
    @Min(value = 10,message = "高不能低于10cm")
    @Digits(message = "高格式错误", integer = 3, fraction = 0)
    private Integer height;
    @ExcelProperty("*重量(单位：吨)")
    @NotNull(message = "重量不能为空")
    @DecimalMax(value = "100",message = "重量不能超过100T")
    @Digits(message = "重量格式错误", integer = 3, fraction = 3)
    private BigDecimal weight;
    @ExcelProperty("*运输服务")
    @NotBlank(message = "运输服务不能为空")
    private String transportName;
    @ExcelProperty("*包装类型")
    @NotBlank(message = "包装类型不能为空")
    private String packageTypeName;
    @ExcelProperty("空箱体积（单位:立方米）")
    @Digits(message = "空箱体积格式错误", integer = 8, fraction = 2)
    private BigDecimal packageVolume;
    @ExcelProperty("空箱存储天数")
    @Digits(message = "空箱存储天数格式错误", integer = 3, fraction = 0)
    private Integer storageDays;
}
