package com.simm.exhibitor.dto.shipment;

import com.simm.exhibitor.vo.shipment.ShipmentDiscountVO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
* Created by Mybatis Generator on 2021/10/26 08:59
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ShipmentOrderDTO implements Serializable {

    /**
     * 展商uniqueId
     */
    private String uniqueId;

    /**
     * 折扣
     */
    private List<ShipmentDiscountVO> reviewDiscounts;

    private Integer pageNum;

    private Integer pageSize;

    /**
     * 年份
     */
    private Integer year;

    /**
     * 搜索关键字
     */
    private String searchKey;

    /**
     * 展馆号
     */
    private String boothId;

    /**
     * 展位号
     */
    private String boothNo;

    /**
     * 是否有承运单
     */
    private Boolean hasShipmentOrder;

    /**
     * 根据人
     */
    private Integer createById;

    /**
     * 订单状态 1 未付款 2 已付部分款 3 已付全款
     */
    private Integer orderStatus;

    /**
     * 打印状态 0 未打印 1 已打印
     */
    private Integer printStatus;
    /**
     * 申报状态 1 未申报 2 已申报 3 已回传申报单
     */
    private Integer declarationStatus;

    /**
     * 预付款状态 1 未付 2 已付
     */
    private Integer waitConfirmMoneyStatus;
    /**
     * 现场付款状态 1 已结清 2 需退回 3 需补费
     */
    private Integer confirmMoneyStatus;

    /**
     * 是否计算未复核折扣
     */
    private Boolean calUnReviewDiscount;

    /**
     * 车牌号
     */
    private String carNo;
}