package com.simm.exhibitor.dubbo.invoice;

import com.github.pagehelper.PageInfo;
import com.simm.exhibitor.bean.invoice.ServiceOrderInvoice;
import com.simm.exhibitor.dto.invoice.ExhibitOrderInvoiceDTO;
import com.simm.exhibitor.dto.invoice.Invoice;
import com.simm.exhibitor.dto.invoice.PaymentDetailLog;
import com.simm.exhibitor.vo.invoice.OrderInvoiceVO;

import java.util.List;

/**
 * @author liutao
 * @since 2024/7/2
 */
public interface InvoiceDubboService {


    /**
     * 查询发票列表
     * @param uniqueId uniqueId
     * @return {@link PaymentDetailLog}
     */
    List<PaymentDetailLog> findOpenInvoiceList(String uniqueId);

    /**
     * 查询发票资料
     * @param id 领款日志id
     * @param platformType 订单类型
     * @return {@link Invoice}
     */
    Invoice findInvoice(Integer id, Integer platformType);
    /**
     * 查询发票资料
     * @param invoiceBaseId 发票id
     * @return {@link Invoice}
     */
    Invoice findInvoice(Integer invoiceBaseId);

    /**
     * 保存发票申请信息
     * @param invoice {@link Invoice}
     */
    void saveInvoice(Invoice invoice);

    /**
     * 更新发票申请信息
     * @param invoice {@link Invoice}
     */
    void updateInvoice(Invoice invoice);

    /**
     * 催开发票
     * @param orderId 订单id
     * @param platformType 1 销售 2 水电 3 承运
     * @param openId 易展通openid
     * @param invoiceBaseId 发票id
     */
    void urgentInvoice(Integer orderId, Integer platformType, String openId, Integer invoiceBaseId);

    /**
     * 根据订单号查询水电订单或承运订单的领款日志
     * @param orderNos 订单号
     * @return {@link PaymentDetailLog}
     */
    List<PaymentDetailLog> findInvoiceListByOrderNo(List<String> orderNos);

    /**
     * 查询水电订单和承运订单开票列表
     * @param exhibitOrderInvoiceDTO {@link ExhibitOrderInvoiceDTO}
     * @return {@link OrderInvoiceVO}
     */
    PageInfo<OrderInvoiceVO> findExhibitOrderInvoicePage(ExhibitOrderInvoiceDTO exhibitOrderInvoiceDTO);

    /**
     * 查询服务订单发票信息
     * @param orderId 订单id
     * @return {@link ServiceOrderInvoice}
     */
    ServiceOrderInvoice findServiceOrderInvoiceByOrderId(Integer orderId);
}
