package com.simm.exhibitor.dubbo.shipment;

import com.simm.exhibitor.bean.shipment.ShipmentDeclareDiscount;
import com.simm.exhibitor.bean.shipment.ShipmentReviewDiscount;
import com.simm.exhibitor.vo.shipment.ShipmentDiscountVO;

import java.util.List;

/**
 * @author liutao
 * @since 2024/8/8
 */
public interface ShipmentDiscountDubboService {

    /**
     * 查询申报折扣
     * @param uniqueId uniqueId
     * @return {@link ShipmentDeclareDiscount}
     */
    List<ShipmentDeclareDiscount> findDeclareDiscountByUniqueId(String uniqueId);
    /**
     * 添加复核折扣
     * @param shipmentDeclareDiscount {@link ShipmentDeclareDiscount}
     */
    void addDeclareDiscount(ShipmentDeclareDiscount shipmentDeclareDiscount);
    /**
     * 添加复核折扣
     * @param shipmentReviewDiscount {@link ShipmentReviewDiscount}
     */
    void addReviewDiscount(ShipmentReviewDiscount shipmentReviewDiscount);

    /**
     * 查询复核折扣
     * @param uniqueId uniqueId
     * @return {@link ShipmentReviewDiscount}
     */
    List<ShipmentReviewDiscount> findReviewDiscountByUniqueId(String uniqueId);

    /**
     * 查询未复核折扣
     * @param uniqueId uniqueId
     * @return {@link ShipmentDiscountVO}
     */
    List<ShipmentDiscountVO> findUnReviewDiscountList(String uniqueId);

    /**
     * 删除复核折扣
     * @param id id
     * @return boolean
     */
    Boolean deleteReviewDiscount(Integer id);

    /**
     * 删除申报折扣
     * @param id id
     * @return boolean
     */
    Boolean deleteDeclareDiscount(Integer id);
}
