package com.simm.exhibitor.dubbo.shipment;

import com.simm.exhibitor.bean.shipment.ShipmentPaymentLog;
import com.simm.exhibitor.vo.invoice.ShipmentPaymentLogVO;

import java.util.List;

/**
 * @author liutao
 * @since 2024/8/7
 */
public interface ShipmentPaymentLogDubboService {

    /**
     * 根据唯一id查询领款日志
     * @param uniqueId uniqueId
     * @return {@link ShipmentPaymentLog}
     */
    List<ShipmentPaymentLog> findByUniqueId(String uniqueId);

    /**
     * 根据唯一id查询领款日志
     * @param uniqueIds uniqueId
     * @return {@link ShipmentPaymentLog}
     */
    List<ShipmentPaymentLog> findByUniqueIds(List<String> uniqueIds);

    /**
     * 领款
     * @param log {@link ShipmentPaymentLog}
     */
    void drawMoney(ShipmentPaymentLog log);

    /**
     * 回滚
     * @param id id
     */
    void rollback(Integer id);

    /**
     * 更新开票状态
     * @param ids id
     * @param openInvoice 开票状态
     */
    void updateOpenInvoiceByIds(List<Integer> ids, Integer openInvoice);

    /**
     * 开票成功
     * @param shipmentPaymentLogs {@link ShipmentPaymentLog}
     */
    void openInvoiceSuccess(List<ShipmentPaymentLog> shipmentPaymentLogs);

    /**
     * 根据发票资料id查询订单id
     * @param invoiceBaseId 发票资料id
     * @return 订单id
     */
    List<Integer> findOrderIdsByInvoiceBaseId(Integer invoiceBaseId);
    /**
     * 根据发票资料id查询领款日志
     * @param invoiceBaseId 发票资料id
     * @return {@link ShipmentPaymentLog}
     */
    List<ShipmentPaymentLog> findByInvoiceBaseId(Integer invoiceBaseId);

    /**
     * 根据订单id查询领款日志
     * @param orderIds 订单id
     * @return {@link ShipmentPaymentLogVO}
     */
    List<ShipmentPaymentLogVO> findPaymentLogInvoiceList(List<Integer> orderIds);

    /**
     * 根据发票资料id查询订单编号
     * @param invoiceBaseId 发票资料id
     * @return 发票资料id
     */
    List<String> findOrderNosByInvoiceBaseId(Integer invoiceBaseId);

    /**
     * 根据id查询发票资料id
     * @param ids id
     * @return 发票资料id
     */
    Integer findInvoiceBaseIdByIds(List<Integer> ids);
}
