package com.simm.exhibitor.dubbo.shipment;

import com.simm.exhibitor.bean.shipment.ShipmentReviewService;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author liutao
 * @since 2024/8/8
 */
public interface ShipmentReviewServiceDubboService {

    /**
     * 取消复核
     * @param id id
     */
    void cancel(Integer id);

    /**
     * 根据uniqueId查询复核服务
     * @param uniqueId uniqueId
     * @return {@link ShipmentReviewService}
     */
    List<ShipmentReviewService> findByUniqueId(String uniqueId);

    /**
     * 根据uniqueId和订单id查询复核服务
     * @param uniqueId uniqueId
     * @param orderId 订单id
     * @return {@link ShipmentReviewService}
     */
    List<ShipmentReviewService> findByUniqueIdAndOrderId(String uniqueId, Integer orderId);

    /**
     * 复核服务
     * @param shipmentReviewService {@link ShipmentReviewService}
     */
    void add(ShipmentReviewService shipmentReviewService);

    /**
     * 更新复核数量
     * @param id id
     * @param quantity 复核数量
     */
    void updateQuantity(Integer id, BigDecimal quantity);

    /**
     * 批量复核
     * @param shipmentReviewServices {@link ShipmentReviewService}
     */
    void batchAdd(List<ShipmentReviewService> shipmentReviewServices);
}
