package com.simm.exhibitor.export;

import com.github.pagehelper.PageInfo;
import com.simm.exhibitor.bean.exhibits.SmebExhibitApplicationIndustry;

import java.util.List;

/**
 * @author liutao
 * @since 2022/12/14
 * 
 */
public interface ExhibitApplicationIndustryExport {


    /**
     * 展商行业分页查询
     * @param exhibitApplicationIndustry 查询条件
     * @return 展商行业分页对象
     */
    PageInfo<SmebExhibitApplicationIndustry> page(SmebExhibitApplicationIndustry exhibitApplicationIndustry);

    /**
     * 更新
     * @param exhibitApplicationIndustry 展商行业对象
     * @return true or false
     */
    boolean update(SmebExhibitApplicationIndustry exhibitApplicationIndustry);

    /**
     * 保存
     * @param exhibitApplicationIndustry 展商行业对象
     * @return true or false
     */
    boolean save(SmebExhibitApplicationIndustry exhibitApplicationIndustry);

    /**
     * 根据Id查询
     * @param id id
     * @return 展商行业对象
     */
    SmebExhibitApplicationIndustry findById(Integer id);

    /**
     * 查询所有展商行业记录
     * @param exhibitApplicationIndustry {@link SmebExhibitApplicationIndustry}
     * @return {@link SmebExhibitApplicationIndustry}
     */
    List<SmebExhibitApplicationIndustry> list(SmebExhibitApplicationIndustry exhibitApplicationIndustry);
}
