package com.simm.exhibitor.export;

import com.github.pagehelper.PageInfo;
import com.simm.exhibitor.bean.basic.ExhibitorBooth;
import com.simm.exhibitor.bean.basic.SmebExhibitorInfo;
import com.simm.exhibitor.bean.basic.SmebExhibitorInfoRole;
import com.simm.exhibitor.bean.exhibitors.SmebExhibitorInfoExhibit;

import java.util.List;

/**
 * @since  2018/12/19 10:54
 **/
public interface SmebExhibitorInfoServiceExport {

    PageInfo<SmebExhibitorInfo> findPageByKeyWord(SmebExhibitorInfo smebExhibitorInfo);

    PageInfo<SmebExhibitorInfo> findItemByPageExternal(SmebExhibitorInfo smebExhibitorInfo);

    PageInfo<SmebExhibitorInfo> findItemByPage(SmebExhibitorInfo smebExhibitorInfo);

    List<SmebExhibitorInfo> findExhibitorInfoList(SmebExhibitorInfo smebExhibitorInfo);

    SmebExhibitorInfo findById(Integer id);

    SmebExhibitorInfo saveOrUpdat(SmebExhibitorInfo smebExhibitorInfo);

    boolean update(SmebExhibitorInfo smebExhibitorInfo);

    /**
     * 更新展商信息和展商展品信息
     * @param smebExhibitorInfo {@link SmebExhibitorInfo}
     * @return true false
     */
    boolean updateExhibitorInfoAndExhibitById(SmebExhibitorInfo smebExhibitorInfo);

    List<SmebExhibitorInfo> selectByModel(SmebExhibitorInfo smebExhibitorInfo);

    List<SmebExhibitorInfoRole> listByExhibitorInfoId(Integer exhibitorInfoId);

    SmebExhibitorInfo selectByUniqueId(String uniqueId);

    /**
     * 根据展商唯一Id查询展商信息
     * @param uniqueIds 展商唯一Id
     * @return 展商信息列表
     */
    List<SmebExhibitorInfo> selectByUniqueIds(List<String> uniqueIds);

    PageInfo<SmebExhibitorInfo> listExhibitorNoPower(SmebExhibitorInfo smebExhibitorInfo);

    PageInfo<SmebExhibitorInfo> findExhibitorInfoPage(SmebExhibitorInfo smebExhibitorInfo);

    PageInfo<SmebExhibitorInfo> unPaidAmountPage(SmebExhibitorInfo smebExhibitorInfo);

    /*修改展位相关信息*/
    boolean updateExhibitorBooth(ExhibitorBooth exhibitorBooth);

    boolean updateExhibitorBoothForOther(ExhibitorBooth exhibitorBooth);

   /* 作废当届数据*/
    boolean updateExhibitorInfo(ExhibitorBooth exhibitorBooth);

    boolean updateExhibitorInfoForOther(ExhibitorBooth exhibitorBooth);

    /*ites*/

    SmebExhibitorInfo findInfoById(Integer id);

    PageInfo<SmebExhibitorInfo> collectExhibitorPage(SmebExhibitorInfo smebExhibitorInfo);

    List<SmebExhibitorInfo> listByIds(List<Integer> ids);

    List<SmebExhibitorInfoExhibit> listExhibitByExhibitorInfoId(Integer exhibitorId);
    /**
     * 根据erp展商id查询
     * @param exhibitorBaseInfoIdList erp展商id集合
     * @return 展商信息集合
     */
    List<SmebExhibitorInfo> findByExhibitorBaseInfoIds(List<Integer> exhibitorBaseInfoIdList);

    /**
     * 根据id集合查询
     * @param ids id
     * @return {@link SmebExhibitorInfo}
     */
    List<SmebExhibitorInfo> findByIds(List<Integer> ids);

    /**
     * 根据展位号查询
     * @param boothNo 展位号
     * @return {@link SmebExhibitorInfo}
     */
    SmebExhibitorInfo findByBoothNo(String boothNo);

    /**
     * 添加承运预付款金额
     * @param uniqueId  uniqueId
     * @param amount 金额
     */
    void addWaitConfirmTotalMoney(String uniqueId, Integer amount);

    /**
     * 减少承运预付款金额
     * @param uniqueId  uniqueId
     * @param amount 金额
     */
    void reduceWaitConfirmMoney(String uniqueId, Integer amount);

}
