package com.simm.exhibitor.export;

import com.simm.exhibitor.bean.shipmentv2.SmebShipmentOrder;
import com.simm.exhibitor.vo.shipment.v2.ShipmentOrderVO;

import java.util.List;

/***
 * 订单接口
 * @author Jone Ying
 * @since 2022/12/14
**/
public interface SmebShipmentOrderExport {

    ShipmentOrderVO createOrder(String uniqueId, List<Integer> discountIds);

    /**
     * 查询已付款的订单
     * @param boothNo 展位号
     * @return {@link SmebShipmentOrder}
     */
    List<SmebShipmentOrder> findPaidOrder(String boothNo);

    /**
     * 根据展商唯一Id查询承运单
     * @param uniqueIds 展商唯一Id
     * @return {@link SmebShipmentOrder}
     */
    List<SmebShipmentOrder> findByUniqueIds(List<String> uniqueIds);

    /**
     * 根据已确认金额状态查询uniqueId
     * @param year 年份
     * @param confirmMoneyStatus 已确认金额状态(1：已结清,2：需补缴，3：需退回)
     * @return uniqueId
     */
    List<String> getUniqueIdsByConfirmMoneyStatus(Integer year,Integer confirmMoneyStatus);
    /**
     * 更新服务订单发票金额
     * @param id id
     * @param openInvoiceAmount 开票金额
     * @param invoiceApply 开票申请状态
     */
    void updateOpenInvoiceAmountById(Integer id, Integer openInvoiceAmount, Integer invoiceApply);

    /**
     * 根据id查询承运订单
     * @param ids id
     * @return {@link SmebShipmentOrder}
     */
    List<SmebShipmentOrder> findByIds(List<Integer> ids);

    /**
     * 批量更新承运订单
     * @param shipmentOrders {@link SmebShipmentOrder}
     */
    void batchUpdate(List<SmebShipmentOrder> shipmentOrders);
}
