package com.simm.exhibitor.export;

import com.github.pagehelper.PageInfo;
import com.simm.exhibitor.bean.shipmentv2.SmebShipmentOrder;
import com.simm.exhibitor.bean.shipmentv2.SmebShipmentOrderService;
import com.simm.exhibitor.dto.shipment.ShipmentOrderDTO;
import com.simm.exhibitor.vo.shipment.v2.ShipmentOrderServiceVO;
import com.simm.exhibitor.vo.shipment.v2.ShipmentOrderVO;

import java.math.BigDecimal;
import java.util.List;

/***
 * 承运订单dubbo接口
 * @author Jone Ying
 * @since  2022/12/14
**/
public interface SmebShipmentOrderServiceExport {

    PageInfo<ShipmentOrderVO> orderPage(ShipmentOrderDTO shipmentOrderDto);

    /**
     * 更新打印状态
     * @param id id
     * @param printStatus 打印状态 0 未打印 1 已打印
     */
    void updatePrintStatus(Integer id, Integer printStatus);

    void rollback(SmebShipmentOrder order);

    /**
     * 根据订单号查询订单
     * @param orderNo 订单号
     * @return ShipmentExhibitorVO
     */
    ShipmentOrderVO findByOrderNo(String orderNo);

    List<ShipmentOrderServiceVO> findPreOrderExhibit(String uniqueId);

    /**
     * 根据uniqueId，订单创建时间查询订单号不为空的承运服务
     * @param hall 展馆
     * @param startDate 开始时间
     * @param endDate 结束时间
     * @return {@link ShipmentOrderServiceVO}
     */
    List<ShipmentOrderServiceVO> findAllByHallAndOrderCreateTimeBetween(String hall,String startDate, String endDate);

    boolean reviewService(SmebShipmentOrderService orderService);

    boolean plusReviewService(Integer id, BigDecimal quantity);

    boolean reduceReviewService(Integer id, BigDecimal quantity);

    boolean deleteReviewService(Integer id);

    void batchReviewExhibit(List<SmebShipmentOrderService> orderServices);

}
