package com.simm.exhibitor.export;

import com.simm.exhibitor.bean.shipmentv2.SmebShipmentPaymentLog;
import com.simm.exhibitor.vo.invoice.ShipmentPaymentLogVO;

import java.util.List;

/***
 * 承运订单领款接口
**/
public interface SmebShipmentPaymentLogServiceExport {


    void addWaitConfirmMoney(String uniqueId, Integer money);

    void reduceWaitConfirmMoney(String uniqueId, Integer money);

    boolean drawMoney(SmebShipmentPaymentLog log);

    void rollback(Integer id);

    List<SmebShipmentPaymentLog> findByUniqueId(String uniqueId);


    List<SmebShipmentPaymentLog> findByUniqueIds(List<String> uniqueIds);

    void updateOpenInvoiceByIds(List<Integer> ids, Integer openInvoice);

    void openInvoiceSuccess(List<SmebShipmentPaymentLog> shipmentPaymentLogs);

    List<Integer> findOrderIdsByInvoiceBaseId(Integer invoiceBaseId);

    List<SmebShipmentPaymentLog> findByInvoiceBaseId(Integer invoiceBaseId);

    List<ShipmentPaymentLogVO> findPaymentLogInvoiceList(List<Integer> orderIds);

    /**
     * 根据发票资料id查询订单编号
     * @param invoiceBaseId 发票资料id
     * @return 订单编号
     */
    List<String> findOrderNosByInvoiceBaseId(Integer invoiceBaseId);

    Integer findInvoiceBaseIdByDetailLogIds(List<Integer> detailLogIds);
}
