package com.simm.exhibitor.export;

import com.github.pagehelper.PageInfo;
import com.simm.exhibitor.bean.basic.SmebExhibitorInfo;
import com.simm.exhibitor.bean.shipment.ShipmentContactLog;
import com.simm.exhibitor.bean.shipmentv2.SmebShipmentService;
import com.simm.exhibitor.vo.shipment.v2.*;

import java.util.List;

public interface SmebShipmentServiceExport {

    PageInfo<ExhibitorInfoVO> findPage(SmebExhibitorInfo exhibitorInfo);

    ShipmentAmountVO findByUniqueId(String uniqueId);

    PageInfo<ShipmentBaseContactLogVO> logPage(ShipmentContactLog log);

    ShipmentTotalAmountVO totalAmount(SmebExhibitorInfo exhibitorInfo);




    void batchAddService(List<SmebShipmentService> services);

    ShipmentServiceVO addService(SmebShipmentService service);

    ShipmentServiceVO updateService(SmebShipmentService service);

    ShipmentServiceVO plusService(Integer id, Integer quantity);


    ShipmentServiceVO reduceService(Integer id, Integer quantity);

    List<ShipmentServiceVO> findListByUniqueId(String uniqueId);

    List<ShipmentServiceBaseVO> findList();

}
