package com.simm.exhibitor.vo.exhibitors;

import com.simm.common.vo.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *  ExhibitorInfoExhibitVO
 * @author chenyong
 * @since 2019/8/27 9:04
 **/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class ExhibitorInfoExhibitVO extends BaseVO {

    @ApiModelProperty("主键id")
    private Integer id;

    @ApiModelProperty("展商id")
    private Integer exhibitorInfoId;

    @ApiModelProperty("展品名")
    private String name;

    @ApiModelProperty("展品英文名")
    private String nameEn;

    @ApiModelProperty("展品介绍")
    private String introduce;

    @ApiModelProperty("展品英文介绍")
    private String introduceEn;

    @ApiModelProperty("展品url")
    private String imgUrl;

    @ApiModelProperty("是否新品，0：否，1：全球首发，2：中国首发")
    private Integer newFlag;

    @ApiModelProperty("展品类型，0：无类型，1：热销类型，2：主打产品，3：口碑产品")
    private Integer type;

    private String industry;

    private String industryEn;
}
