package com.simm.exhibitor.vo.invoice;

import lombok.Data;

import java.io.Serializable;

/**
 * @author liutao
 * @since 2024/7/2
 */
@Data
public class OrderInvoiceVO implements Serializable {

    /**
     * id
     */
    private Integer id;
    /**
     * 订单号
     */
    private String orderNo;
    /**
     * 展商id
     */
    private Integer exhibitorId;
    /**
     * 展商名称
     */
    private String exhibitorName;
    /**
     * 合同公司名称
     */
    private String agreementExhibitName;
    /**
     * 产品类型
     */
    private Integer productType;
    /**
     * 产品名称
     */
    private String productName;
    /**
     * 合同金额
     */
    private Integer agreementAmount;
    /**
     * 已付金额
     */
    private Integer paidAmount;
    /**
     * 开票金额
     */
    private Integer openInvoiceAmount;
    /**
     * 发票数量
     */
    private Integer invoiceCount;
    /**
     * 展商唯一id
     */
    private String uniqueId;
    /**
     * 发票申请
     */
    private String invoiceTime;
    /**
     * 开票状态 1 未开票 2 已开票
     */
    private Integer openInvoice;
    /**
     * 主办方公司名
     */
    private String sponsorName;
    /**
     * 主办方id
     */
    private Integer sponsorId;
    /**
     * 发票申请状态
     */
    private Integer invoiceApply;
    /**
     * 催开发票
     */
    private Integer urgentInvoice;
    /**
     * 1 销售订单 2 水电订单 3 承运订单
     */
    private Integer platformType;
}
