package com.simm.exhibitor.vo.shipment;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author liutao
 * @since 2023/9/11
 */
@Data
@ColumnWidth(30)
public class ShipmentExhibitExcelVO implements Serializable {

    @ExcelProperty("公司名称")
    private String businessName;

    @ExcelProperty("展位号")
    private String boothNo;

    @ExcelProperty("服务单号")
    private String orderNo;

    @ExcelProperty("体积(立方米)")
    private BigDecimal volume;

    @ExcelProperty("重量(千克)")
    private Integer weight;

    @ExcelProperty("包装类型")
    private String packageType;

    @ExcelProperty("空箱体积(立方米)")
    private BigDecimal packageVolume;

    @ExcelProperty("空箱存储金额(元)")
    private BigDecimal packageAmount;

    @ExcelProperty("空箱搬运金额(元")
    private BigDecimal emptyContainerAmount;

    @ExcelProperty("进出馆金额(元)")
    private BigDecimal transportAmount;

    @ExcelProperty("超重超限金额(元)")
    private BigDecimal overAmount;

    @ExcelProperty("金额(元)")
    private BigDecimal amount;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ExcelProperty("申报时间")
    private String declarationTime;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ExcelProperty("作业时间")
    private String workDate;
}
