package com.simm.exhibitor.vo.shipment.v2;

import com.simm.common.vo.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *  ExhibitorInfoVO
 * @author chenyong
 * @since 2018/12/26 14:29
 **/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class ExhibitorInfoVO extends BaseVO {

    private Integer id;

    @ApiModelProperty("展商id")
    private Integer exhibitorBaseinfoId;

    @ApiModelProperty("编号")
    private String uniqueId;

    @ApiModelProperty("公司名")
    private String businessName;

    @ApiModelProperty("公司名简称")
    private String businessNameShort;

    @ApiModelProperty("公司英文名称")
    private String businessNameEn;

    @ApiModelProperty("logo地址")
    private String logoUrl;

    @ApiModelProperty("展馆")
    private String boothId;

    @ApiModelProperty("展位号")
    private String boothNo;

    @ApiModelProperty("展位面积")
    private Double boothArea;

    @ApiModelProperty("展位类型")
    private Integer boothType;


    @ApiModelProperty("展品类别")
    private String exhibitsCategory;

    @ApiModelProperty("是否提交承运承建信息")
    private Boolean shipment = false;

    @ApiModelProperty("联系人")
    private String contactName;

    @ApiModelProperty("联系电话")
    private String contactMobile;

    @ApiModelProperty("预计作业时间")
    private String workDate;

    @ApiModelProperty("车牌")
    private String carNo;

    @ApiModelProperty("车牌图片")
    private String carNoUrl;

    @ApiModelProperty("申报总额(单位：分)")
    private Integer totalAmount;

    @ApiModelProperty("服务单金额(单位：分)")
    private Integer orderAmount;

    @ApiModelProperty("实收金额(单位：分)")
    private Integer actualAmount;

    @ApiModelProperty("未付金额(单位：分)")
    private Integer unpaidAmount;

    @ApiModelProperty("已付金额(单位：分)")
    private Integer paidAmount;

    @ApiModelProperty("申报单url")
    private String declarationUrl;

    @ApiModelProperty("回签申报单url")
    private String declarationSignUrl;

    @ApiModelProperty("申报状态（1：未申报,2：一申报，3：已回传申报单）")
    private Integer declarationStatus;

    @ApiModelProperty("待领款金额状态（1：未预付款,2:已预付款）")
    private Integer waitConfirmMoneyStatus;

    @ApiModelProperty("预付款总金额")
    private Integer waitConfirmTotalMoney;

    @ApiModelProperty("待领款金额")
    private Integer waitConfirmMoney;

    @ApiModelProperty("已确认金额状态(1：已结清,2：需补缴，3：需退回)")
    private Integer confirmMoneyStatus;

    private Boolean hasShipmentOrder;

}
