package com.simm.exhibitor.vo.shipment.v2;

import com.simm.exhibitor.bean.shipmentv2.SmebShipmentDiscount;
import com.simm.exhibitor.bean.shipmentv2.SmebShipmentExhibit;
import com.simm.exhibitor.bean.shipmentv2.SmebShipmentService;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author liutao
 * @since 2023/11/2
 */
@Data
public class ShipmentAmountCalculateResult {

    @ApiModelProperty("总金额")
    private Integer totalAmount;

    @ApiModelProperty("进出馆总金额")
    private Integer transportAmount;

    @ApiModelProperty("超重超限总金额")
    private Integer overrunAmount;

    @ApiModelProperty("空箱存储总金额")
    private Integer packageAmount;

    @ApiModelProperty("优惠抹零总金额")
    private Integer discountAmount;

    @ApiModelProperty("优惠券集合")
    private List<ShipmentDiscountVO> discountVos;

    @ApiModelProperty("三件超重超限优惠总金额")
    private Integer overrunDiscountAmount;

    @ApiModelProperty("空箱存储优惠金额")
    private Integer packageDiscountAmount;

    @ApiModelProperty("本单满足三件优惠，补回前面订单的超重超限优惠金额")
    private Integer historyOverrunDiscountAmount;

    @ApiModelProperty("优惠后总金额")
    private Integer finalAmount;

    @ApiModelProperty("服务金额")
    private Integer serviceAmount;

    @ApiModelProperty("超重超限数量")
    private Integer overrunCount;

    @ApiModelProperty("展品id")
    private List<Integer> exhibitIds;

    @ApiModelProperty("参与计算的展品")
    private List<SmebShipmentExhibit> exhibits;

    @ApiModelProperty("参与计算的服务")
    private List<SmebShipmentService> services;

    @ApiModelProperty("参与计算的折扣")
    private List<SmebShipmentDiscount> discounts;

    @ApiModelProperty("服务单服务")
    private List<com.simm.exhibitor.bean.shipmentv2.SmebShipmentOrderService> orderServices;

    @ApiModelProperty("超重超限展品id")
    private List<Integer> overExhibitIds;
}
