package com.simm.exhibitor.vo.shipment.v2;

import com.simm.common.vo.BaseVO;
import com.simm.exhibitor.bean.shipmentv2.SmebShipmentDiscount;
import com.simm.exhibitor.bean.shipmentv2.SmebShipmentExhibit;
import com.simm.exhibitor.bean.shipmentv2.SmebShipmentService;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
* Created by Mybatis Generator on 2021/07/14 09:19
*/
@Data
@ApiModel
public class ShipmentAmountVO extends BaseVO {

    @ApiModelProperty("总金额")
    private Integer totalAmount;

    @ApiModelProperty("进出馆总金额")
    private Integer transportAmount;

    @ApiModelProperty("超重超限总金额")
    private Integer overrunAmount;

    @ApiModelProperty("空箱存储总金额")
    private Integer packageAmount;

    @ApiModelProperty("优惠抹零总金额")
    private Integer discountAmount;

    @ApiModelProperty("优惠券集合")
    private List<ShipmentDiscountVO> discountVos;

    @ApiModelProperty("三件超重超限优惠总金额")
    private Integer overrunDiscountAmount;

    @ApiModelProperty("空箱存储优惠金额")
    private Integer packageDiscountAmount;

    @ApiModelProperty("本单满足三件优惠，补回前面订单的超重超限优惠金额")
    private Integer historyOverrunDiscountAmount;

    @ApiModelProperty("优惠后总金额")
    private Integer finalAmount;

    @ApiModelProperty("展品集合")
    private List<ShipmentExhibitVO> exhibitVos;

    @ApiModelProperty("服务集合")
    private List<ShipmentServiceVO> serviceVos;

    @ApiModelProperty("服务金额")
    private Integer serviceAmount;

    @ApiModelProperty("超重超限数量")
    private Integer overrunCount;

    @ApiModelProperty("展品id")
    private List<Integer> exhibitIds;
    @ApiModelProperty("超重超限展品id")
    private List<Integer> overExhibitIds;
}