package com.simm.exhibitor.vo.shipment.v2;

import com.simm.common.vo.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
* Created by Mybatis Generator on 2021/07/14 09:19
*/
@Data
@ApiModel
public class ShipmentExhibitVO extends BaseVO {
    @ApiModelProperty("id")
    private Integer id;

    @ApiModelProperty("展商id")
    private String uniqueId;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("展品名称")
    private String name;

    @ApiModelProperty("展品类别")
    private String category;

    @ApiModelProperty("公司名")
    private String businessName;

    @ApiModelProperty("包装类型(1:包装,2:裸机)")
    private Integer packageType;

    @ApiModelProperty("空箱体积(cm³)")
    private Double packageVolume;

    @ApiModelProperty("空箱存储天数")
    private Integer storageDays;

    @ApiModelProperty("是否按重量收费")
    private Boolean weightBilling;

    @ApiModelProperty("展品长(单位:cm)")
    private Integer len;

    @ApiModelProperty("展品宽(单位:cm)")
    private Integer width;

    @ApiModelProperty("展品高(单位:cm)")
    private Integer height;

    @ApiModelProperty("展品体积(cm³)")
    private Integer volume;

    @ApiModelProperty("运输服务(1:进馆,2:出馆,3:进出馆)")
    private Integer transport;

    @ApiModelProperty("运输金额(单位：分)")
    private Integer transportAmount;

    @ApiModelProperty("包装存储金额(单位：分)")
    private Integer packageAmount;

    @ApiModelProperty("超限金额(单位：分)")
    private Integer overrunAmount;

    @ApiModelProperty("超重金额(单位：分)")
    private Integer overweightAmount;

    @ApiModelProperty("展品重量(单位:公斤)")
    private Integer weight;

    @ApiModelProperty("复核状态(0:待复核，1:已复核)")
    private Boolean review;

    @ApiModelProperty("包装类型(1:包装,2:裸机)")
    private Integer reviewPackageType;

    @ApiModelProperty("空箱存储体积(cm³)")
    private Double reviewPackageVolume;

    @ApiModelProperty("空箱是否存储(0:否，1:是)")
    private Boolean reviewStore;

    @ApiModelProperty("空箱存储天数")
    private Integer reviewStorageDays;

    @ApiModelProperty("是否按重量收费")
    private Boolean reviewWeightBilling;

    @ApiModelProperty("展品长(单位:cm)")
    private Integer reviewLen;

    @ApiModelProperty("展品宽(单位:cm)")
    private Integer reviewWidth;

    @ApiModelProperty("展品高(单位:cm)")
    private Integer reviewHeight;

    @ApiModelProperty("展品体积(cm³)")
    private Integer reviewVolume;

    @ApiModelProperty("展品重量(单位:公斤)")
    private Integer reviewWeight;

    @ApiModelProperty("运输服务(1:进馆,2:出馆,3:进出馆)")
    private Integer reviewTransport;

    @ApiModelProperty("运输金额(单位：分)")
    private Integer reviewTransportAmount;

    @ApiModelProperty("包装存储金额(单位：分)")
    private Integer reviewPackageAmount;

    @ApiModelProperty("超限金额(单位：分)")
    private Integer reviewOverrunAmount;

    @ApiModelProperty("超重金额(单位：分)")
    private Integer reviewOverweightAmount;

    @ApiModelProperty("订单状态")
    private Integer orderStatus;

    @ApiModelProperty("申报方式(1:预申报，2:现场录入)")
    private Integer declareType;

    @ApiModelProperty("备注")
    private String remark;
    @ApiModelProperty("展馆")
    private String boothId;
    @ApiModelProperty("申报时间")
    private Date declarationTime;
    @ApiModelProperty("订单创建时间")
    private Date orderCreateTime;
}