package com.simm.exhibitor.vo.shipment.v2;

import com.simm.common.vo.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
* Created by Mybatis Generator on 2021/10/26 08:59
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class ShipmentOrderVO extends BaseVO {

    @ApiModelProperty("id")
    private Integer id;

    @ApiModelProperty("展商id")
    private String uniqueId;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("作业时间")
    private String workDate;

    @ApiModelProperty("订单金额")
    private Integer amount;

    @ApiModelProperty("实际金额")
    private Integer actualAmount;

    @ApiModelProperty("已付金额")
    private Integer paidAmount;

    @ApiModelProperty("已付金额")
    private Integer unPaidAmount;

    @ApiModelProperty("订单状态(1:已付款,2:未付款,3:对公未付)")
    private Integer orderStatus;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("展商名称")
    private String exhibitorName;

    @ApiModelProperty("展馆号")
    private String boothId;

    @ApiModelProperty("展位号")
    private String boothNo;

    @ApiModelProperty("展位类型(1:标摊,2:光地)")
    private Integer boothType;

    @ApiModelProperty("联系人")
    private String contactName;

    @ApiModelProperty("联系电话")
    private String contactMobile;

    @ApiModelProperty("车牌")
    private String carNo;

    @ApiModelProperty("年份")
    private Integer year;

    @ApiModelProperty("展会名（合同需要）")
    private String exhibitTitle;

    @ApiModelProperty("展会名称")
    private String exhibitName;

    @ApiModelProperty("展会时间")
    private String exhibitTime;

    @ApiModelProperty("展会地点")
    private String exhibitAddress;

    @ApiModelProperty("主办方公司名称")
    private String sponsorName;
    @ApiModelProperty("主办方公司网址")
    private String sponsorWebsite;

    @ApiModelProperty("现场缴费金额")
    private Integer sceneAmount;

    @ApiModelProperty("进出馆金额")
    private Integer transportAmount;

    @ApiModelProperty("超重超限金额")
    private Integer overrunAmount;

    @ApiModelProperty("空箱存储金额")
    private Integer packageAmount;

    private Integer urgentInvoice;

    private Integer openInvoice;

    @ApiModelProperty("超重超限优惠金额")
    private Integer overrunDiscountAmount;

    @ApiModelProperty("空箱存储优惠金额")
    private Integer packageDiscountAmount;

    @ApiModelProperty("本单满足三件优惠，补回前面订单的超重超限优惠金额")
    private Integer historyOverrunDiscountAmount;

    @ApiModelProperty("其它优惠金额")
    private Integer otherDiscountAmount;

    @ApiModelProperty("打印状态(0:未打印,1:已打印)")
    private Integer printStatus;

    private Integer invoiceCount;

    private Integer openInvoiceAmount;

    @ApiModelProperty("优惠券集合")
    private List<ShipmentDiscountVO> discountVos;

    @ApiModelProperty("订单服务项目集合")
    private List<ShipmentOrderServiceVO> orderServiceVos;

    @ApiModelProperty("展品集合")
    private List<ShipmentExhibitVO> exhibitVos;

}