package com.simm.exhibitor.bean.reservation;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
* Created by Mybatis Generator on 2019/12/24 13:34
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmebServiceKind extends BaseBean {
    @ApiModelProperty("主键id")
    private Integer id;

    @ApiModelProperty("种类名称")
    private String kindName;

    @ApiModelProperty("")
    private String kindNameEn;

    @ApiModelProperty("结算方式")
    private String paymentMethod;

    @ApiModelProperty("提示")
    private String prompt;

    @ApiModelProperty("英文提示")
    private String promptEn;

    @ApiModelProperty("展位类型（1:标摊,2:光地）")
    private String boothType;

    @ApiModelProperty("启用(1:是,0:否)")
    private Integer enable;

    @ApiModelProperty("排序")
    private Integer sort;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建人id")
    private Integer createById;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新人")
    private String lastUpdateBy;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("备注")
    private String remark;

    //冗余字段
    private List<Integer> roleIds;
}