package com.simm.exhibitor.bean.reservation;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
* Created by Mybatis Generator on 2021/11/02 17:00
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmebServiceOrderDetail extends BaseBean {
    @ApiModelProperty("主键id")
    private Integer id;

    @ApiModelProperty("展商唯一id")
    private String exhibitorUniqueId;

    @ApiModelProperty("订单id")
    private Integer orderId;

    @ApiModelProperty("服务明细id（smeb_service_list.id）")
    private Integer serviceListId;

    @ApiModelProperty("服务明细name")
    private String serviceListName;

    @ApiModelProperty("服务种类")
    private String serviceKindName;

    @ApiModelProperty("规格")
    private String specifica;

    @ApiModelProperty("展馆结算价")
    private Integer innerPrice;

    @ApiModelProperty("单价")
    private Integer leasePrice;

    @ApiModelProperty("总数量")
    private Integer total;

    @ApiModelProperty("总金额")
    private Integer totalPrice;

    @ApiModelProperty("状态(1:正常,-1:异常)")
    private Integer status;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新人")
    private String lastUpdateBy;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("备注")
    private String remark;


    //冗余字段
    @ApiModelProperty("数量")
    private Integer detailCount;

    @ApiModelProperty("订单状态")
    private Integer orderStatus;
}