package com.simm.exhibitor.bean.shipment;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.simm.common.bean.BaseBean;
import java.util.Date;

import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
* Created by Mybatis Generator on 2024/07/29 09:47
*/
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ShipmentDeclare extends BaseBean {


    /**
     * id
     */
    private Integer id;

    /**
     * 展商id
     */
    private String uniqueId;

    /**
     * 公司名
     */
    private String businessName;

    /**
     * 展馆id
     */
    private String boothId;

    /**
     * 展位号
     */
    private String boothNo;

    /**
     * 联系人
     */
    @NotBlank(message = "联系人不能为空")
    private String contactName;

    /**
     * 联系电话
     */
    @NotBlank(message = "联系电话不能为空")
    private String contactMobile;

    /**
     * 作业时间
     */
    @NotNull(message = "作业时间不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date workDate;

    /**
     * 车牌
     */
    private String carNo;

    /**
     * 原价申报服务金额
     */
    private Integer originDeclareServiceAmount;

    /**
     * 申报服务金额
     */
    private Integer declareServiceAmount;

    /**
     * 原价进出馆金额
     */
    private Integer originTransportAmount;

    /**
     * 进出馆金额
     */
    private Integer transportAmount;

    /**
     * 原价空箱存储金额
     */
    private Integer originPackageAmount;

    /**
     * 空箱存储金额
     */
    private Integer packageAmount;
    /**
     * 原价超限金额(单位：分)
     */
    private Integer originOverrunAmount;

    /**
     * 超限金额(单位：分)
     */
    private Integer overrunAmount;

    /**
     * 原价超重金额
     */
    private Integer originOverweightAmount;

    /**
     * 超重金额(单位：分)
     */
    private Integer overweightAmount;

    /**
     * 原价空箱搬运金额(单位：分)
     */
    private Integer originEmptyContainerAmount;
    /**
     * 空箱搬运金额(单位：分)
     */
    private Integer emptyContainerAmount;

    /**
     * 主办优惠金额
     */
    private Integer discountAmount;

    /**
     * 申报总额(单位：分)
     */
    private Integer totalAmount;

    /**
     * 实际金额(单位：分)
     */
    private Integer actualAmount;

    /**
     * 申报单url
     */
    private String declarationUrl;

    /**
     * 申报时间
     */
    private Date declarationTime;

    /**
     * 回签申报单url
     */
    private String declarationSignUrl;

    /**
     * 回签申报单时间
     */
    private Date declarationSignTime;

    /**
     * 备注
     */
    private String remark;

    /**
     * 是否锁定
     */
    private Boolean declarationLock;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 最后更新时间
     */
    private Date lastUpdateTime;
}