package com.simm.exhibitor.bean.shipment;

import com.simm.common.bean.BaseBean;
import java.math.BigDecimal;
import java.util.Date;

import lombok.*;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;

/**
* Created by Mybatis Generator on 2024/07/29 09:52
*/
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ShipmentDeclareExhibit extends BaseBean {

    /**
     * id
     */
    private Integer id;

    /**
     * 展商id
     */
    private String uniqueId;

    /**
     * 包装类型(1:包装,2:裸机)
     */
    @NotNull(message = "包装类型不能为空")
    private Integer packageType;

    /**
     * 空箱体积(cm³)
     */
    private BigDecimal packageVolume;
    /**
     * 空箱存储天数
     */
    private Integer storageDays;

    /**
     * 是否按重量收费
     */
    private Boolean weightBilling;

    /**
     * 展品长(单位:cm)
     */
    @NotNull(message = "展品长度不能为空")
    @Max(value = 2000, message = "展品长度不能超过20m")
    private Integer len;

    /**
     * 展品宽(单位:cm)
     */
    @NotNull(message = "展品宽度不能为空")
    @Max(value = 600, message = "展品宽度不能超过6m")
    private Integer width;

    /**
     * 展品高(单位:cm)
     */
    @NotNull(message = "展品高度不能为空")
    @Max(value = 600, message = "展品高度不能超过6m")
    private Integer height;

    /**
     * 展品体积(cm³)
     */
    private Integer volume;

    /**
     * 运输服务(1:进馆,2:出馆,3:进出馆)
     */
    @NotNull(message = "展品高度不能为空")
    private Integer transport;

    /**
     * 原价运输金额
     */
    private Integer originTransportAmount;

    /**
     * 运输金额(单位：分)
     */
    private Integer transportAmount;

    /**
     * 原价包装存储金额
     */
    private Integer originPackageAmount;

    /**
     * 包装存储金额(单位：分)
     */
    private Integer packageAmount;

    /**
     * 原价超限金额(单位：分)
     */
    private Integer originOverrunAmount;

    /**
     * 超限金额(单位：分)
     */
    private Integer overrunAmount;

    /**
     * 原价超重金额
     */
    private Integer originOverweightAmount;

    /**
     * 超重金额(单位：分)
     */
    private Integer overweightAmount;

    /**
     * 原价空箱搬运金额(单位：分)
     */
    private Integer originEmptyContainerAmount;
    /**
     * 空箱搬运金额(单位：分)
     */
    private Integer emptyContainerAmount;

    /**
     * 展品重量(单位:公斤)
     */
    @NotNull(message = "展品重量不能为空")
    private Integer weight;

    /**
     * 复核状态(0:待复核，1:已复核)
     */
    private Boolean review;

    /**
     * 0 被清空 1 正常
     */
    private Integer status;
    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 最后更新时间
     */
    private Date lastUpdateTime;
}