package com.simm.exhibitor.bean.shipment;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
* Created by Mybatis Generator on 2022/12/06 09:16
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmebShipmentExhibitService extends BaseBean {
    @ApiModelProperty("id")
    private Integer id;

    @ApiModelProperty("服务类别")
    private String type;

    @ApiModelProperty("服务项目")
    private String name;

    @ApiModelProperty("原价")
    private Integer originalPrice;

    @ApiModelProperty("单价")
    private Integer price;

    @ApiModelProperty("描述")
    private String description;

    private Integer minWeight;

    private Integer maxWeight;

    @ApiModelProperty("限长(单位:cm）")
    private Integer length;

    @ApiModelProperty("限宽(单位:cm)")
    private Integer width;

    @ApiModelProperty("限高(单位:cm)")
    private Integer height;

    @ApiModelProperty("单位")
    private String unit;

    @ApiModelProperty("预申报截止时间")
    private Date preEndDate;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;
}