package com.simm.exhibitor.export;

import com.simm.exhibitor.bean.reservation.SmebServiceOrderDetail;

import java.util.List;

/**
 * @author liutao
 * @since 2022/11/23
 * 
 */
public interface SmebServiceOrderDetailServiceExport {


    /**
     * 订单明细查询
     * @param orderId 订单ID
     * @return {@link SmebServiceOrderDetail}
     */
    List<SmebServiceOrderDetail> findByOrderId(Integer orderId);


    /**
     * 取消订单明细
     * @param orderDetailId 添加订单明细id
     * @return true
     * @throws Exception Exception
     */
    boolean cancelOrderDetail(Integer orderDetailId) throws Exception;

    /**
     * 添加订单明细
     * @param smebServiceOrderDetail smebServiceOrderDetail
     * @return true
     */
    boolean addOrderDetail(SmebServiceOrderDetail smebServiceOrderDetail);

    /**
     * 添加多个订单服务明细
     * @param serviceOrderDetails serviceOrderDetails
     * @return true
     * @throws Exception Exception
     */
    boolean addOrderDetails(List<SmebServiceOrderDetail> serviceOrderDetails) throws Exception;
}
