package com.simm.exhibitor.vo.basic;

import com.simm.common.vo.BaseVO;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 
 *  权限VO
 *
 * @author YingJH
 * @since 2018年7月9日
 * @version v1.1
 */
public class AuthVO extends BaseVO{

	private static final long serialVersionUID = 8731417581311163661L;

	@ApiModelProperty("主键id")
	private Integer id;

	@ApiModelProperty("父级id")
	private Integer pid;

	@ApiModelProperty("权限名称")
	private String name;

	@ApiModelProperty("权限名称英文")
	private String nameEn;

	@ApiModelProperty("描述")
	private String description;

	@ApiModelProperty("路由")
	private String route;

	@ApiModelProperty("url地址")
	private String url;

	@ApiModelProperty("菜单(0:否,1:是)")
	private Integer isMenu;

	@ApiModelProperty("是否在手机端展示（0：否，1：是）")
	private Integer isMobile;

	@ApiModelProperty("菜单图标")
	private String icon;

	@ApiModelProperty("按钮生效开始时间")
	private Date buttonEffectStartTime;

	@ApiModelProperty("按钮生效结束时间")
	private Date buttonEffectEndTime;

	@ApiModelProperty("是否启用(1:启用,-1:禁用)")
	private Integer enable;

	@ApiModelProperty("状态(1:正常,-1:异常)")
	private Integer status;

	@ApiModelProperty("排序字段")
	private Integer sort;
    
	@ApiModelProperty(value ="子权限集合")
    private List<AuthVO> list = new ArrayList<AuthVO>();

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public Integer getPid() {
		return pid;
	}

	public void setPid(Integer pid) {
		this.pid = pid;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getNameEn() {
		return nameEn;
	}

	public void setNameEn(String nameEn) {
		this.nameEn = nameEn;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getRoute() {
		return route;
	}

	public void setRoute(String route) {
		this.route = route;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public Integer getIsMenu() {
		return isMenu;
	}

	public void setIsMenu(Integer isMenu) {
		this.isMenu = isMenu;
	}

	public String getIcon() {
		return icon;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}

	public Date getButtonEffectStartTime() {
		return buttonEffectStartTime;
	}

	public void setButtonEffectStartTime(Date buttonEffectStartTime) {
		this.buttonEffectStartTime = buttonEffectStartTime;
	}

	public Date getButtonEffectEndTime() {
		return buttonEffectEndTime;
	}

	public void setButtonEffectEndTime(Date buttonEffectEndTime) {
		this.buttonEffectEndTime = buttonEffectEndTime;
	}

	public Integer getEnable() {
		return enable;
	}

	public void setEnable(Integer enable) {
		this.enable = enable;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}

	public List<AuthVO> getList() {
		return list;
	}

	public void setList(List<AuthVO> list) {
		this.list = list;
	}

	public Integer getIsMobile() {
		return isMobile;
	}

	public void setIsMobile(Integer isMobile) {
		this.isMobile = isMobile;
	}
}
