package com.simm.exhibitor.vo.reservation;

import com.simm.common.bean.BaseBean;
import com.simm.common.vo.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
* Created by Mybatis Generator on 2021/11/02 17:00
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class ServiceOrderDetailVO extends BaseVO {
    @ApiModelProperty("主键id")
    private Integer id;

    @ApiModelProperty("展商唯一id")
    private String exhibitorUniqueId;

    @ApiModelProperty("订单id")
    private Integer orderId;

    @ApiModelProperty("服务明细id（smeb_service_list.id）")
    private Integer serviceListId;

    @ApiModelProperty("服务明细name")
    private String serviceListName;

    @ApiModelProperty("服务种类")
    private String serviceKindName;

    @ApiModelProperty("规格")
    private String specifica;

    @ApiModelProperty("单价")
    private Integer leasePrice;

    @ApiModelProperty("总数量")
    private Integer total;

    @ApiModelProperty("总金额")
    private Integer totalPrice;

    @ApiModelProperty("状态(1:正常,-1:异常)")
    private Integer status;

    @ApiModelProperty("备注")
    private String remark;
}