package com.simm.exhibitor.bean.reservation;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
* Created by Mybatis Generator on 2019/01/02 14:05
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmebServiceOrderTemp extends BaseBean {
    @ApiModelProperty("主键id")
    private Integer id;

    @ApiModelProperty("展商唯一id")
    private String exhibitorUniqueId;

    @ApiModelProperty("服务明细id（smeb_service_list.id）")
    private Integer serviceListId;

    @ApiModelProperty("总数量")
    private Integer total;

    @ApiModelProperty("状态(1:正常,-1:异常)")
    private Integer status;

    @ApiModelProperty("服务明细名")
    private String serviceListName;

    @ApiModelProperty("服务明细名")
    private String serviceListNameEn;

    @ApiModelProperty("规格")
    private String specifica;

    @ApiModelProperty("英文规格")
    private String specificaEn;

    @ApiModelProperty("服务种类")
    private String serviceKindName;

    @ApiModelProperty("服务种类")
    private String serviceKindNameEn;

    @ApiModelProperty("展馆结算价")
    private int innerPrice;

    @ApiModelProperty("单价")
    private Integer leasePrice;

    @ApiModelProperty("图标")
    private String imgUrl;

    @ApiModelProperty("总价")
    private Integer totalPrice;
}