package com.simm.exhibitor.bean.shipment;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;

import lombok.*;

/**
* Created by Mybatis Generator on 2024/07/31 11:34
*/
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class ShipmentReviewService extends BaseBean {
    @ApiModelProperty("id")
    private Integer id;

    @ApiModelProperty("展商id")
    private String uniqueId;

    @ApiModelProperty("申报服务id")
    private Integer declareServiceId;

    @ApiModelProperty("订单id")
    private Integer orderId;

    @ApiModelProperty("服务类型")
    private String type;

    @ApiModelProperty("服务名称")
    private String name;

    @ApiModelProperty("单价")
    private Integer price;

    private String unit;

    @ApiModelProperty("原价总金额")
    private Integer originTotalAmount;

    @ApiModelProperty("实际总金额")
    private Integer totalAmount;

    @ApiModelProperty("数量")
    private BigDecimal quantity;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;
}