package com.simm.exhibitor.vo.shipment;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author liutao
 * @since 2024/8/5
 */
@Data
public class ShipmentExhibitorVO implements Serializable {

    /**
     * 展商uniqueId
     */
    private String uniqueId;

    /**
     * 已领金额
     */
    private Integer paidAmount;

    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 公司名称
     */
    private String businessName;

    /**
     * 展位号
     */
    private String boothNo;

    /**
     * 展位类型
     */
    private Integer boothType;

    /**
     * 展位面积
     */
    private Double boothArea;

    /**
     * 申报金额
     */
    private Integer declareAmount;

    /**
     * 预付款总金额
     */
    private Integer waitConfirmTotalMoney;

    /**
     * 预付款金额
     */
    private Integer waitConfirmMoney;
    /**
     * 预付款状态 1 未付 2 已付
     */
    private Integer waitConfirmMoneyStatus;
    /**
     * 1：结清，2：需退回，3：需补费
     */
    private Integer confirmMoneyStatus;

    /**
     * 申报id
     */
    private Integer declareId;

    /**
     * 申报状态
     */
    private Integer declarationStatus;

    /**
     * 申报url
     */
    private String declarationUrl;

    /**
     * 申报单回签url
     */
    private String declarationSignUrl;

    /**
     * 订单金额
     */
    private Integer orderAmount;
    /**
     * 未付金额
     */
    private Integer unpaidAmount;
    /**
     * 更新时间
     */
    private String lastUpdateTime;
}
