package com.simm.exhibitor.vo.shipment;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.simm.exhibitor.bean.shipment.ShipmentReviewDiscount;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author liutao
 * @since 2024/8/6
 */
@Data
public class ShipmentOrderVO implements Serializable {

    /**
     * 订单id
     */
    private Integer id;
    /**
     * 公司名称
     */
    private String businessName;
    /**
     * 展位号
     */
    private String boothNo;
    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 车牌号
     */
    private String carNo;
    /**
     * 原价订单金额
     */
    private Integer amount;
    /**
     * 服务单金额
     */
    private Integer actualAmount;
    /**
     * 已付金额
     */
    private Integer paidAmount;
    /**
     * 未付金额
     */
    private Integer unpaidAmount;

    /**
     * 进出馆金额
     */
    private Integer transportAmount;

    /**
     * 超限金额
     */
    private Integer overrunAmount;

    /**
     * 包装存储金额
     */
    private Integer packageAmount;

    /**
     * 原价超重金额
     */
    private Integer originOverweightAmount;

    /**
     * 超重金额
     */
    private Integer overweightAmount;

    /**
     * 原价包装存储金额
     */
    private Integer originPackageAmount;

    /**
     * 原价超限金额
     */
    private Integer originOverrunAmount;

    /**
     * 原价进出馆金额
     */
    private Integer originTransportAmount;

    /**
     * 原价申报服务金额
     */
    private Integer originServiceAmount;

    /**
     * 复核服务金额
     */
    private Integer serviceAmount;
    /**
     * 原价空箱搬运金额(单位：分)
     */
    private Integer originEmptyContainerAmount;
    /**
     * 空箱搬运金额(单位：分)
     */
    private Integer emptyContainerAmount;

    /**
     * 其它优惠金额
     */
    private Integer discountAmount;
    /**
     * 已开票金额
     */
    private Integer openInvoiceAmount;
    /**
     * 发票状态
     */
    private Integer openInvoice;
    /**
     * 发票数量
     */
    private Integer invoiceCount;
    /**
     * 平台类型
     */
    private Integer platformType;
    /**
     * 打印状态
     */
    private Integer printStatus;
    /**
     * 发票状态
     */
    private Integer invoiceStatus;
    /**
     * 上次更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date lastUpdateTime;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 复核折扣
     */
    private List<ShipmentReviewDiscount> discounts;
}
