package com.simm.exhibitor.bean.car;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
* Created by Mybatis Generator on 2019/12/12 15:27
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmebBluecarInfo extends BaseBean {
    @ApiModelProperty("")
    private Integer id;

    @ApiModelProperty("展商唯一id")
    private String exhibitorUniqueId;

    @ApiModelProperty("公司名")
    private String comFullName;

    @ApiModelProperty("展位号")
    private String boothNo;

    @ApiModelProperty("车牌号码")
    private String carNo;

    @ApiModelProperty("车辆所有人")
    private String carOwner;

    @ApiModelProperty("联系人姓名")
    private String contactName;

    @ApiModelProperty("联系人电话")
    private String contactMobile;

    @ApiModelProperty("图片地址(多个以逗号,分隔)")
    private String fileUrl;

    @ApiModelProperty("合成图片地址")
    private String synthesisFileUrl;

    @ApiModelProperty("临时证件")
    private String temporaryNo;

    @ApiModelProperty("证件开始时间")
    private Date effectiveStartTime;

    @ApiModelProperty("证件结束时间")
    private Date effectiveEndTime;

    @ApiModelProperty("审核状态（0：未，1：已）")
    private Integer approveStatus;

    @ApiModelProperty("状态(1:正常,-1:删除)")
    private Integer status;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    //冗余
    private String boothId;
}