package com.simm.exhibitor.bean.exhibitors;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
* Created by Mybatis Generator on 2019/08/26 16:59
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmebExhibitorInfoExhibit extends BaseBean {
    @ApiModelProperty("主键id")
    private Integer id;

    @ApiModelProperty("展商id")
    private Integer exhibitorInfoId;

    @ApiModelProperty("展品名")
    private String name;

    @ApiModelProperty("展品英文名")
    private String nameEn;

    @ApiModelProperty("展品介绍")
    private String introduce;

    @ApiModelProperty("展品英文介绍")
    private String introduceEn;

    @ApiModelProperty("展品url")
    private String imgUrl;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新人")
    private String lastUpdateBy;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("备注")
    private String remark;

    private Integer year;

    //查询参数
    @ApiModelProperty("届数")
    private Integer number;

    @ApiModelProperty("展品分类名")
    private Integer exhibitCategoryName;

    @ApiModelProperty("应用行业名")
    private String  applicationIndustryName;

    @ApiModelProperty("主键ids")
    private List<Integer> ids;

    //展示字段
    @ApiModelProperty("展商名")
    private String exhibitorName;

    @ApiModelProperty("展商log")
    private String exhibitorLogUrl;

    @ApiModelProperty("展商展位号")
    private String exhibitorBoothNo;

    @ApiModelProperty("是否新品，0：否，1：全球首发，2：中国首发")
    private Integer newFlag;

    @ApiModelProperty("展品类型，0：无类型，1：热销类型，2：主打产品，3：口碑产品")
    private Integer type;

    @ApiModelProperty("主要行业")
    private String industry;

    @ApiModelProperty("主要行业(英文)")
    private String industryEn;

}