package com.simm.exhibitor.dubbo.hydropower;

import com.github.pagehelper.PageInfo;
import com.simm.exhibitor.bean.reservation.SmebServiceOrder;
import com.simm.exhibitor.bean.reservation.SmebServiceOrderDetail;

import java.util.List;

/**
 * @author chenyong
 * @since  2019/1/16 14:06
 **/
public interface ServiceOrderDubboService {

    List<SmebServiceOrder> ListByBName(String businessName);

    SmebServiceOrder findById(Integer id);

    void update(SmebServiceOrder smebServiceOrder);

    void updateOrder(SmebServiceOrder smebServiceOrder);

    List<SmebServiceOrder> findByIds(List<Integer> ids);

    void batchUpdate( List<SmebServiceOrder> orders);

    PageInfo<SmebServiceOrder> findServiceOrderPage(SmebServiceOrder serviceOrder, List<String> exhibitName, Integer number, Integer year,String boothId,List<Integer> exhibitorIds,Integer status);

    SmebServiceOrder selectWhloleAmountByModel(SmebServiceOrder serviceOrder, List<String> exhibitName, Integer number, Integer year, String boothId, List<Integer> exhibitorIds);

    List<SmebServiceOrder> serviceOrderList(SmebServiceOrder serviceOrder, List<String> exhibitName, Integer number, Integer year,String boothId,Integer status);

    int unpaidAmount(String uniqueId);

    List<SmebServiceOrder> listByUniqueId(String uniqueId);

    void batchHide(List<Integer> ids, String reason);

    Boolean setBatchNo(Integer[] ids ,String batchNo);

    List<SmebServiceOrder>   waitClaimOrderByBusinessName(String businessName);

    PageInfo<SmebServiceOrderDetail> statisticsByServiceListId(SmebServiceOrderDetail orderDetail);

    /**
     * 作废订单
     * @param exhibitorId 展商Id
     */
    void cancelOrder(Integer exhibitorId);

    /**
     * 查询服务订单列表
     * @param serviceOrder 查询参数
     * @return 服务订单列表
     */
    List<SmebServiceOrder> list(SmebServiceOrder serviceOrder);
    /**
     * 删除订单
     * @param exhibitorUniqueId 展商唯一id
     */
    void removeByExhibitorUniqueId(String exhibitorUniqueId);
    /**
     * 查询已付款的订单
     * @param boothNo 展位号
     * @return {@link SmebServiceOrder}
     */
    List<SmebServiceOrder> findPaidOrder(String boothNo);

    /**
     * 更新服务订单发票金额
     * @param id id
     * @param openInvoiceAmount 开票金额
     * @param invoiceApply 开票申请状态
     */
    void updateOpenInvoiceAmountById(Integer id, Integer openInvoiceAmount, Integer invoiceApply);
}
