package com.simm.exhibitor.bean.basic;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
* Created by Mybatis Generator on 2019/03/14 14:53
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmebAuth extends BaseBean {
    @ApiModelProperty("主键id")
    private Integer id;

    @ApiModelProperty("父级id")
    private Integer pid;

    @ApiModelProperty("权限名称")
    private String name;

    @ApiModelProperty("权限名称英文")
    private String nameEn;

    @ApiModelProperty("描述")
    private String description;

    @ApiModelProperty("路由")
    private String route;

    @ApiModelProperty("url地址")
    private String url;

    @ApiModelProperty("菜单(0:否,1:是)")
    private Integer isMenu;

    @ApiModelProperty("是否在手机端展示（0：否，1：是）")
    private Integer isMobile;

    @ApiModelProperty("菜单图标")
    private String icon;

    @ApiModelProperty("按钮生效开始时间")
    private Date buttonEffectStartTime;

    @ApiModelProperty("按钮生效结束时间")
    private Date buttonEffectEndTime;

    @ApiModelProperty("是否启用(1:启用,-1:禁用)")
    private Integer enable;

    @ApiModelProperty("状态(1:正常,-1:异常)")
    private Integer status;

    @ApiModelProperty("排序字段")
    private Integer sort;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新人")
    private String lastUpdateBy;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("备注")
    private String remark;

    //冗余字段
    private List<Integer> buttonConfigurations;

    private List<SmebMenuButtonConfiguration> buttonList;
}