package com.simm.exhibitor.bean.exhibitors;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 *  ExhibitorData
 * @author chenyong
 * @since 2019/9/18 15:20
 **/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class ExhibitorData implements Serializable {

    private String projectName;

    @ApiModelProperty("已提交展商各种资料统计")
    private Integer hasCommitCount;

    @ApiModelProperty("已提交展商Unqiueid-压缩值")
    private String hasCommitExhibitorUnqiueIds;

    @ApiModelProperty("未提交展商各种资料统计")
    private Integer noCommitCount;

    @ApiModelProperty("未提交展商Unqiueid")
    private String noCommitExhibitorUnqiueIds;
}
