package com.simm.exhibitor.bean.invoice;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
* Created by Mybatis Generator on 2024/07/15 10:10
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class ServiceOrderInvoice extends BaseBean {
    @ApiModelProperty("")
    private Integer id;

    @ApiModelProperty("展商唯一id")
    private String uniqueId;

    @ApiModelProperty("订单id")
    private Integer orderId;

    @ApiModelProperty("展商id")
    private Integer exhibitorId;

    @ApiModelProperty("公司名称")
    private String businessName;

    @ApiModelProperty("税号")
    private String taxpayerNo;

    @ApiModelProperty("纳税人类型 1 一般纳税人 2 非一般纳税人")
    private Integer taxpayerType;

    @ApiModelProperty("发票类型 1 专票 2 普票")
    private Integer invoiceType;

    @ApiModelProperty("营业执照")
    private String businessLicenseUrl;

    @ApiModelProperty("发票收件人邮箱")
    private String recipientsEmail;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;
}