package com.simm.exhibitor.bean.reservation;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
* Created by Mybatis Generator on 2018/12/29 09:18
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmebServiceList extends BaseBean {
    @ApiModelProperty("主键id")
    private Integer id;

    @ApiModelProperty("服务种类（smeb_service_kind.id）")
    private Integer serviceKindId;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("英文名称")
    private String nameEn;

    @ApiModelProperty("图片路径")
    private String imgUrl;

    @ApiModelProperty("规格")
    private String specifica;

    @ApiModelProperty("英文规格")
    private String specificaEn;

    @ApiModelProperty("单位")
    private String unit;

    @ApiModelProperty("英文单位")
    private String unitEn;

    @ApiModelProperty("展馆结算价")
    private Integer innerPrice;

    @ApiModelProperty("价格备注")
    private String priceRemark;

    @ApiModelProperty("英文价格备注")
    private String priceRemarkEn;

    @ApiModelProperty("押金")
    private Integer deposit;

    @ApiModelProperty("启用(1:是,0:否)")
    private Integer enable;

    @ApiModelProperty("排序")
    private Integer sort;

    //冗余字段
    @ApiModelProperty("自定义价格段")
    private List<SmebServiceListPrice> priceList;

    @ApiModelProperty("服务种类集合")
    private List<Integer> serviceKindIds;

    @ApiModelProperty("服务种类名")
    private String serviceKindName;

    @ApiModelProperty("购物车数量")
    private Integer orderTempTotal;

    private String uniqueId;

}