package com.simm.exhibitor.dto.exhibitor;

import com.simm.exhibitor.bean.exhibitors.ExhibitCategory;
import com.simm.exhibitor.bean.exhibits.SmebExhibitApplicationIndustry;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author liutao
 * @since 2024/10/21
 */
@Data
public class ExhibitApplicationIndustryDTO implements Serializable {


    @ApiModelProperty("")
    private Integer id;

    @ApiModelProperty("名称")
    @NotBlank(message = "中文名称不能为空")
    private String name;

    @ApiModelProperty("")
    @NotBlank(message = "英文名称不能为空")
    private String nameEn;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("状态(1:正常，-1:异常)")
    private Integer status;

    @ApiModelProperty("年份")
    @NotNull(message = "年份不能为空")
    private Integer year;

    @ApiModelProperty("排序")
    private Integer sort;

    private Integer pageNum;

    private Integer pageSize;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;


    private List<ExhibitCategory> childList;
}
