package com.simm.exhibitor.dubbo.shipment;

import com.simm.exhibitor.bean.shipment.ShipmentReviewExhibit;

import java.util.List;

/**
 * @author liutao
 * @since 2024/8/8
 */
public interface ShipmentReviewExhibitDubboService {

    /**
     * 复核展品
     * @param shipmentReviewExhibit {@link ShipmentReviewExhibit}
     */
    void add(ShipmentReviewExhibit shipmentReviewExhibit);

    /**
     * 取消复核
     * @param id id
     */
    void cancel(Integer id);

    /**
     * 根据uniqueId查询复核展品
     * @param uniqueId uniqueId
     * @return {@link ShipmentReviewExhibit}
     */
    List<ShipmentReviewExhibit> findByUniqueId(String uniqueId);

    /**
     * 根据uniqueId和orderId查询复核展品
     * @param uniqueId uniqueId
     * @param orderId 订单id
     * @return {@link ShipmentReviewExhibit}
     */
    List<ShipmentReviewExhibit> findByUniqueIdAndOrderId(String uniqueId, Integer orderId);

    /**
     * 铺批量复核
     * @param shipmentReviewExhibits {@link ShipmentReviewExhibit}
     */
    void batchAdd(List<ShipmentReviewExhibit> shipmentReviewExhibits);
}
